rm(list=ls())
library(copula)
tau<-0.8  # dependence parameter
theta<-iTau(claytonCopula(dim=2),tau=tau)
lam1<-2     # in-control parameter of first variable
lam2<-2     # in-control parameter of second variable
lam11<-2*1    # out-control parameter of first variable
lam12<-2*1 # out-control parameter of second variable
#### Estamation of mean of T=min(y_i1,Y_i2)
if(theta>=0)
{
  Fvar<-function(t)
  {-1+exp(-t/lam1)+exp(-t/lam2)+((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)}
} else {Fvar<-function(t)
{-1+exp(-t/lam1)+exp(-t/lam2)+(max(0,(1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1))^(-1/theta)}}
A=integrate(Fvar,0,+Inf)
ET<-A$value
alpha<-ET/370
alpha1<-alpha*3/4
alpha2<-alpha*1/4
###### Calculating of LCL for downward shifts
if(theta<0) 
  LCL<-uniroot(function(t)   2-exp(-t/lam1)-exp(-t/lam2)-alpha1 , lower = 0, upper = 10)$ root

if(theta>=0)
  LCL<-uniroot(function(t) 2-exp(-t/lam1)-exp(-t/lam2)-((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)-alpha1 , lower = 0, upper = 1000)$ root
###### Calculating of LCL for downward shifts
UCL<-uniroot(function(t) 2-exp(-t/lam1)-exp(-t/lam2)-((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)+alpha2-1 , lower = 2, upper = 1000)$ root



#### Calculating the type II error

F<-function(lam1,lam2,t)
{
  2-exp(-t/lam1)-exp(-t/lam2)- max(0,((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1))^(-1/theta)
}

beta<-F(lam11,lam12,UCL)-F(lam11,lam12,LCL)
if(theta>=0)
{
  Fvar<-function(t)
  {-1+exp(-t/lam11)+exp(-t/lam12)+((1-exp(-t/lam11))^(-theta)+(1-exp(-t/lam12))^(-theta)-1)^(-1/theta)}
} else {Fvar<-function(t)
{-1+exp(-t/lam11)+exp(-t/lam12)+(max(0,(1-exp(-t/lam11))^(-theta)+(1-exp(-t/lam12))^(-theta)-1))^(-1/theta)}}
A=integrate(Fvar,0,+Inf)
ET1<-A$value
ATS1<-(1/(1-beta))*ET1
ATS1
